************************************************************
dis 'Nonlinear  SURE  Panel estimation "Applied Econometrics" (2013)'
Nonlinear  SURE  Panel estimation "Applied Econometrics" (2013)
dis 'Written by Tolga Omay 2012'
Written by Tolga Omay 2012
dis '**************************************************************************'
**************************************************************************
*************************************************************
* Data input as excell file; organize data as time series country by country  ****
cal 1970
all 2014:1
open data "F:\Users\PhD Thesis\PhD Papers\Paper 3\Sure1\data_paper3_70.xlsx"
data(org=obs,format=xlsx) / y1 misal1 ect1 y2 misal2 ect2 y3 misal3 ect3 y4 misal4 ect4	y5 misal5 ect5	y6 misal6 ect6 y7 misal7 ect7 y8 misal8	ect8 y9	misal9	ect9 y10 misal10 ect10	y11 misal11 ect11 y12 misal12 ect12 y13	misal13	ect13 y14 misal14 ect14


**************************************************************************************************************************************
** y for log of gdp, ect for ecm, misal for misalignment, open for openess, gvt for gvt cons and invest for investment
**************************************************************************************************************************************
* compute the growth rates of GDP and other variables. Here we have 14 countries in this prg
*****************************************************************************************************************************************
set   gdp1 =y1-y1{1}
set   gdp2 =y2-y2{1}
set   gdp3 =y3-y3{1}
set   gdp4 =y4-y4{1}
set   gdp5 =y5-y5{1}
set   gdp6 =y6-y6{1}
set   gdp7 =y7-y7{1}
set   gdp8 =y8-y8{1}
set   gdp9 =y9-y9{1}
set   gdp10 =y10-y10{1}
set   gdp11 =y11-y11{1}
set   gdp12 =y12-y12{1}
set   gdp13 =y13-y13{1}
set   gdp14 =y14-y14{1}

set   dmisal1 =misal1-misal1{1}
set   dmisal2 =misal2-misal2{1}
set   dmisal3 =misal3-misal3{1}
set   dmisal4 =misal4-misal4{1}
set   dmisal5 =misal5-misal5{1}
set   dmisal6 =misal6-misal6{1}
set   dmisal7 =misal7-misal7{1}
set   dmisal8 =misal8-misal8{1}
set   dmisal9 =misal9-misal9{1}
set   dmisal10 =misal10-misal10{1}
set   dmisal11 =misal11-misal11{1}
set   dmisal12 =misal12-misal12{1}
set   dmisal13 =misal13-misal13{1}
set   dmisal14 =misal14-misal14{1}



set ortgdp = (gdp1+gdp2+gdp3+gdp4+gdp5+gdp6+gdp7+gdp8+gdp9+gdp10+gdp11+gdp12+gdp13+gdp14)/14

set ortdmisal = (dmisal1+dmisal2+dmisal3+dmisal4+dmisal5+dmisal6+dmisal7+dmisal8+dmisal9+dmisal10+dmisal11+dmisal12+dmisal13+dmisal14)/14

set ortect = (ect1+ect2+ect3+ect4+ect5+ect6+ect7+ect8+ect9+ect10+ect11+ect12+ect13+ect14)/14


*************************************************************************
* Compute transition function by using the below instructions
************************************************************************

* define transition function for misal
stat(noprint) ortdmisal; com se = sqrt(%variance)
compute gamma = 5.941074284
compute c = -0.16189


set TV = dmisal1{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal1 = TF*dmisal1
set tfgdp1 = TF*gdp1
set tfect1 = TF*ect1

set TV = dmisal2{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal2 = TF*dmisal2
set tfgdp2 = TF*gdp2
set tfect2 = TF*ect2

set TV = dmisal3{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal3 = TF*dmisal3
set tfgdp3 = TF*gdp3
set tfect3 = TF*ect3


set TV = dmisal4{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal4 = TF*dmisal4
set tfgdp4 = TF*gdp4
set tfect4 = TF*ect4


set TV = dmisal5{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal5 = TF*dmisal5
set tfgdp5 = TF*gdp5
set tfect5 = TF*ect5


set TV = dmisal6{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal6 = TF*dmisal6
set tfgdp6 = TF*gdp6
set tfect6 = TF*ect6


set TV = dmisal7{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal7 = TF*dmisal7
set tfgdp7 = TF*gdp7
set tfect7 = TF*ect7


set TV = dmisal8{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal8 = TF*dmisal8
set tfgdp8 = TF*gdp8
set tfect8 = TF*ect8


set TV = dmisal9{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal9 = TF*dmisal9
set tfgdp9 = TF*gdp9
set tfect9 = TF*ect9


set TV = dmisal10{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal10 = TF*dmisal10
set tfgdp10 = TF*gdp10
set tfect10 = TF*ect10


set TV = dmisal11{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal11 = TF*dmisal11
set tfgdp11 = TF*gdp11
set tfect11 = TF*ect11


set TV = dmisal12{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal12 = TF*dmisal12
set tfgdp12 = TF*gdp12
set tfect12 = TF*ect12


set TV = dmisal13{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal13 = TF*dmisal13
set tfgdp13 = TF*gdp13
set tfect13 = TF*ect13


set TV = dmisal14{2}
set tol = (-gamma*(TV-c))/se
set tolga = 1+exp(tol)
set TF = 1/tolga
set tfdmisal14 = TF*dmisal14
set tfgdp14 = TF*gdp14
set tfect14 = TF*ect14



************************************************************************************************
*We have obtained the second regimes variables by multiplying them by transition functions
************************************************************************************************
*estimate linear model with sure for initial guess for nonlinear model
************************************************************************************************
lin(noprint,define=gdp1neq) gdp1 / rn1
#  * gdp1{1} tfgdp1{1} ect1{1} tfect1{1} dmisal1{1} tfdmisal1{1}
com  a0 = %beta(1), a11 = %beta(2), b11 = %beta(3), c11 = %beta(4), d11 = %beta(5), e11 = %beta(6), f11 = %beta(7)

lin(noprint,define=gdp2neq) gdp2 / rn2
#  * gdp2{1}  tfgdp2{1} ect2{1} tfect2{1} dmisal2{1} tfdmisal2{1}
com  a1 = %beta(1), a21 = %beta(2), b21 = %beta(3), c21 = %beta(4), d21 = %beta(5), e21 = %beta(6), f21 = %beta(7)

lin(noprint,define=gdp3neq) gdp3 / rn3
#  * gdp3{1}  tfgdp3{1} ect3{1} tfect3{1} dmisal3{1} tfdmisal3{1}
com  a3 = %beta(1), a31 = %beta(2), b31 = %beta(3), c31 = %beta(4), d31 = %beta(5), e31 = %beta(6), f31 = %beta(7)

lin(noprint,define=gdp4neq) gdp4 / rn4
#  * gdp4{1}  tfgdp4{1} ect4{1} tfect4{1} dmisal4{1} tfdmisal4{1}
com  a4 = %beta(1), a41 = %beta(2), b41 = %beta(3), c11 = %beta(4), d41 = %beta(5), e41 = %beta(6), f41 = %beta(7)

lin(noprint,define=gdp5neq) gdp5 / rn5
#  * gdp5{1}  tfgdp5{1} ect5{1} tfect5{1} dmisal5{1} tfdmisal5{1}
com  a5 = %beta(1), a51 = %beta(2), b51 = %beta(3), c51 = %beta(4), d51 = %beta(5), e51 = %beta(6), f51 = %beta(7)

lin(noprint,define=gdp6neq) gdp6 / rn6
#  * gdp6{1}  tfgdp6{1} ect6{1}  tfect6{1} dmisal6{1} tfdmisal6{1}
com  a6 = %beta(1), a61 = %beta(2), b61 = %beta(3), c61 = %beta(4), d61 = %beta(5), e61 = %beta(6), f61 = %beta(7)

lin(noprint,define=gdp7neq) gdp7 / rn7
#  * gdp7{1}  tfgdp7{1} ect7{1} tfect7{1} dmisal7{1} tfdmisal7{1}
com  a7 = %beta(1), a71 = %beta(2), b71 = %beta(3), c71 = %beta(4), d71 = %beta(5), e71 = %beta(6), f71 = %beta(7)

lin(noprint,define=gdp8neq) gdp8 / rn8
#  * gdp8{1}  tfgdp8{1} ect8{1} tfect8{1} dmisal8{1}  tfdmisal8{1}
com  a8 = %beta(1), a81 = %beta(2), b81 = %beta(3), c81 = %beta(4), d81 = %beta(5), e81 = %beta(6), f81 = %beta(7)

lin(noprint,define=gdp9neq) gdp9 / rn9
#  * gdp9{1}  tfgdp9{1} ect9{1} tfect9{1} dmisal9{1}  tfdmisal9{1}
com  a9 = %beta(1), a91 = %beta(2), b91 = %beta(3), c91 = %beta(4), d91 = %beta(5), e91 = %beta(6), f91 = %beta(7)

lin(noprint,define=gdp10neq) gdp10 / rn10
#  * gdp10{1}  tfgdp10{1} ect10{1} tfect10{1} dmisal10{1}  tfdmisal10{1}
com  a10 = %beta(1), a101 = %beta(2), b101 = %beta(3), c101 = %beta(4) , d101 = %beta(5), e101 = %beta(6), f101 = %beta(7)

lin(noprint,define=gdp11neq) gdp11 / rn11
#  * gdp11{1}  tfgdp11{1} ect11{1} tfect11{1} dmisal11{1}  tfdmisal11{1}
com  a11 = %beta(1), a111 = %beta(2), b111 = %beta(3), c111 = %beta(4) , d111 = %beta(5), e111 = %beta(6), f111 = %beta(7)

lin(noprint,define=gdp12neq) gdp12 / rn12
#  * gdp12{1}  tfgdp12{1} ect12{1} tfect12{1} dmisal12{1}  tfdmisal12{1}
com  a12 = %beta(1), a121 = %beta(2), b121 = %beta(3), c121 = %beta(4) , d121 = %beta(5), e121 = %beta(6), f121 = %beta(7)

lin(noprint,define=gdp13neq) gdp13 / rn13
#  * gdp13{1}  tfgdp13{1} ect13{1} tfect13{1} dmisal13{1}  tfdmisal13{1}
com  a13 = %beta(1), a131 = %beta(2), b131 = %beta(3), c131 = %beta(4) , d131 = %beta(5), e131 = %beta(6), f131 = %beta(7)

lin(noprint,define=gdp14neq) gdp14 / rn14
#  * gdp14{1}  tfgdp14{1} ect14{1} tfect14{1} dmisal14{1}  tfdmisal14{1}
com  a14 = %beta(1), a141 = %beta(2), b141 = %beta(3), c141 = %beta(4) , d141 = %beta(5), e141 = %beta(6), f141 = %beta(7)

lin(noprint,define=dmisal1neq) dmisal1 / rn15
#  * gdp1{1} tfgdp1{1} ect1{1} tfect1{1} dmisal1{1} tfdmisal1{1}
com  a0 = %beta(1), a11 = %beta(2), b11 = %beta(3), c11 = %beta(4), d11 = %beta(5), e11 = %beta(6), f11 = %beta(7)

lin(noprint,define=dmisal2neq) dmisal2 / rn16
#  * gdp2{1}  tfgdp2{1} ect2{1} tfect2{1} dmisal2{1} tfdmisal2{1}
com  a1 = %beta(1), a21 = %beta(2), b21 = %beta(3), c21 = %beta(4), d21 = %beta(5), e21 = %beta(6), f21 = %beta(7)

lin(noprint,define=dmisal3neq) dmisal3 / rn17
#  * gdp3{1}  tfgdp3{1} ect3{1} tfect3{1} dmisal3{1} tfdmisal3{1}
com  a3 = %beta(1), a31 = %beta(2), b31 = %beta(3), c31 = %beta(4), d31 = %beta(5), e31 = %beta(6), f31 = %beta(7)

lin(noprint,define=dmisal4neq) dmisal4 / rn18
#  * gdp4{1}  tfgdp4{1} ect4{1} tfect4{1} dmisal4{1} tfdmisal4{1}
com  a4 = %beta(1), a41 = %beta(2), b41 = %beta(3), c11 = %beta(4), d41 = %beta(5), e41 = %beta(6), f41 = %beta(7)

lin(noprint,define=dmisal5neq) dmisal5 / rn19
#  * gdp5{1}  tfgdp5{1} ect5{1} tfect5{1} dmisal5{1} tfdmisal5{1}
com  a5 = %beta(1), a51 = %beta(2), b51 = %beta(3), c51 = %beta(4), d51 = %beta(5), e51 = %beta(6), f51 = %beta(7)

lin(noprint,define=dmisal6neq) dmisal6 / rn20
#  * gdp6{1}  tfgdp6{1} ect6{1}  tfect6{1} dmisal6{1} tfdmisal6{1}
com  a6 = %beta(1), a61 = %beta(2), b61 = %beta(3), c61 = %beta(4), d61 = %beta(5), e61 = %beta(6), f61 = %beta(7)

lin(noprint,define=dmisal7neq) dmisal7 / rn21
#  * gdp7{1}  tfgdp7{1} ect7{1} tfect7{1} dmisal7{1} tfdmisal7{1}
com  a7 = %beta(1), a71 = %beta(2), b71 = %beta(3), c71 = %beta(4), d71 = %beta(5), e71 = %beta(6), f71 = %beta(7)

lin(noprint,define=dmisal8neq) dmisal8 / rn22
#  * gdp8{1}  tfgdp8{1} ect8{1} tfect8{1} dmisal8{1}  tfdmisal8{1}
com  a8 = %beta(1), a81 = %beta(2), b81 = %beta(3), c81 = %beta(4), d81 = %beta(5), e81 = %beta(6), f81 = %beta(7)

lin(noprint,define=dmisal9neq) dmisal9 / rn23
#  * gdp9{1}  tfgdp9{1} ect9{1} tfect9{1} dmisal9{1}  tfdmisal9{1}
com  a9 = %beta(1), a91 = %beta(2), b91 = %beta(3), c91 = %beta(4), d91 = %beta(5), e91 = %beta(6), f91 = %beta(7)

lin(noprint,define=dmisal10neq) dmisal10 / rn24
#  * gdp10{1}  tfgdp10{1} ect10{1} tfect10{1} dmisal10{1}  tfdmisal10{1}
com  a10 = %beta(1), a101 = %beta(2), b101 = %beta(3), c101 = %beta(4), d101 = %beta(5), e101 = %beta(6), f101 = %beta(7)

lin(noprint,define=dmisal11neq) dmisal11 / rn25
#  * gdp11{1}  tfgdp11{1} ect11{1} tfect11{1} dmisal11{1}  tfdmisal11{1}
com  a11 = %beta(1), a111 = %beta(2), b111 = %beta(3), c111 = %beta(4), d111 = %beta(5), e111 = %beta(6), f111 = %beta(7)

lin(noprint,define=dmisal12neq) dmisal12 / rn26
#  * gdp12{1}  tfgdp12{1} ect12{1} tfect12{1} dmisal12{1}  tfdmisal12{1}
com  a12 = %beta(1), a121 = %beta(2), b121 = %beta(3), c121 = %beta(4), d121 = %beta(5), e121 = %beta(6), f121 = %beta(7)

lin(noprint,define=dmisal13neq) dmisal13 / rn27
#  * gdp13{1}  tfgdp13{1} ect13{1} tfect13{1} dmisal13{1}  tfdmisal13{1}
com  a13 = %beta(1), a131 = %beta(2), b131 = %beta(3), c131 = %beta(4), d131 = %beta(5), e131 = %beta(6), f131 = %beta(7)

lin(noprint,define=dmisal14neq) dmisal14 / rn28
#  * gdp14{1}  tfgdp14{1} ect14{1} tfect14{1} dmisal14{1}  tfdmisal14{1}
com  a14 = %beta(1), a141 = %beta(2), b141 = %beta(3), c141 = %beta(4), d141 = %beta(5), e141 = %beta(6), f141 = %beta(7)


stat(noprint) rn1 ; com s1 = %variance
stat(noprint) rn2 ; com s2 = %variance
stat(noprint) rn3 ; com s3 = %variance
stat(noprint) rn4 ; com s4 = %variance
stat(noprint) rn5 ; com s5 = %variance
stat(noprint) rn6 ; com s6 = %variance
stat(noprint) rn7 ; com s7 = %variance
stat(noprint) rn8 ; com s8 = %variance
stat(noprint) rn9 ; com s9 = %variance
stat(noprint) rn10 ; com s10 = %variance
stat(noprint) rn11 ; com s111 = %variance
stat(noprint) rn12 ; com s12 = %variance
stat(noprint) rn13 ; com s13 = %variance
stat(noprint) rn14 ; com s14 = %variance
stat(noprint) rn15 ; com s15 = %variance
stat(noprint) rn16 ; com s16 = %variance
stat(noprint) rn17 ; com s17 = %variance
stat(noprint) rn18 ; com s18 = %variance
stat(noprint) rn19 ; com s19 = %variance
stat(noprint) rn20 ; com s20 = %variance
stat(noprint) rn21 ; com s21 = %variance
stat(noprint) rn22 ; com s221 = %variance
stat(noprint) rn23 ; com s23 = %variance
stat(noprint) rn24 ; com s24 = %variance
stat(noprint) rn25 ; com s25 = %variance
stat(noprint) rn26 ; com s26 = %variance
stat(noprint) rn27 ; com s27 = %variance
stat(noprint) rn28 ; com s28 = %variance



smpl 1 28
set s11 = 0.0
com s11(1) = s1
set s22 = 0.0
com s22(2) = s2
set s33 = 0.0
com s33(3) = s3
set s44 = 0.0
com s44(4) = s4
set s55 = 0.0
com s55(5) = s5
set s66 = 0.0
com s66(6) = s6
set s77 = 0.0
com s77(7) = s7
set s88 = 0.0
com s88(8) = s8
set s99 = 0.0
com s99(9) = s9
set s1010 = 0.0
com s1010(10) = s10
set s1111 = 0.0
com s1111(11) = s111
set s1212 = 0.0
com s1212(12) = s12
set s1313 = 0.0
com s1313(13) = s13
set s1414 = 0.0
com s1414(14) = s14
set s1515 = 0.0
com s1515(15) = s15
set s1616 = 0.0
com s1616(16) = s16
set s1717 = 0.0
com s1717(17) = s17
set s1818 = 0.0
com s1818(18) = s18
set s1919 = 0.0
com s1919(19) = s19
set s2020 = 0.0
com s2020(20) = s20
set s2121 = 0.0
com s2121(21) = s21
set s2222 = 0.0
com s2222(22) = s221
set s2323 = 0.0
com s2323(23) = s23
set s2424 = 0.0
com s2424(24) = s24
set s2525 = 0.0
com s2525(25) = s25
set s2626 = 0.0
com s2626(26) = s26
set s2727 = 0.0
com s2727(27) = s27
set s2828 = 0.0
com s2828(28) = s28



make sn 1 28
# s11 s22 s33 s44 s55 s66 s77 s88 s99  s1010 s1111 s1212 s1313 s1414 s1515 s1616 s1717 s1818 s1919 s2020 s2121 s2222 s2323 s2424 s2525 s2626 s2727 s2828


*dis sn
smpl 1 45

*dis '*****Estimation results of Linear SURE panel****'
sur(iter=150,isigma=sn,nosigma,noprint) 28
# gdp1neq
# gdp2neq
# gdp3neq
# gdp4neq
# gdp5neq
# gdp6neq
# gdp7neq
# gdp8neq
# gdp9neq
# gdp10neq
# gdp11neq
# gdp12neq
# gdp13neq
# gdp14neq
# dmisal1neq
# dmisal2neq
# dmisal3neq
# dmisal4neq
# dmisal5neq
# dmisal6neq
# dmisal7neq
# dmisal8neq
# dmisal9neq
# dmisal10neq
# dmisal11neq
# dmisal12neq
# dmisal13neq
# dmisal14neq

com  a0 = %beta(1), a11 = %beta(2), b11 = %beta(3) , c11 = %beta(4) , d11 = %beta(5), e11 = %beta(6), f11=%beta(7)$
, a1 = %beta(8), a21 = %beta(9), b21 = %beta(10) , c21 = %beta(11), d21 = %beta(12), e21 = %beta(13), f21=%beta(14)$
, a2 = %beta(15), a31 = %beta(16), b31 = %beta(17) , c31 = %beta(18), d31 = %beta(19), e31 = %beta(20), f31=%beta(21)$
, a3 = %beta(22), a41 = %beta(23), b41 = %beta(24) , c41 = %beta(25) , d41 = %beta(26), e41 = %beta(27), f41=%beta(28)$
, a4 = %beta(29), a51 = %beta(30), b51 = %beta(31) , c51 = %beta(32), d51 = %beta(33), e51 = %beta(34), f51=%beta(35)$
, a5 = %beta(36), a61 = %beta(37), b61 = %beta(38) , c61 = %beta(39) , d61 = %beta(40), e61 = %beta(41), f61=%beta(42)$
, a6 = %beta(43), a71 = %beta(44), b71 = %beta(45) , c71 = %beta(46) , d71 = %beta(47), e71 = %beta(48), f71=%beta(49)$
, a7 = %beta(50), a81 = %beta(51), b81 = %beta(52) , c81 = %beta(53) , d81 = %beta(54), e81 = %beta(55), f81=%beta(56)$
, a8 = %beta(57), a91 = %beta(58), b91 = %beta(59) , c91 = %beta(60) , d91 = %beta(61), e91 = %beta(62), f91=%beta(63)$
, a9 = %beta(64), a101 = %beta(65), b101 = %beta(66), c101 = %beta(67), d101 = %beta(68), e101 = %beta(69), f101=%beta(70)$
, a100 = %beta(71), a111 = %beta(72), b111 = %beta(73) , c111 = %beta(74), d111 = %beta(75), e111 = %beta(76), f111=%beta(77)$
, a110 = %beta(78), a121 = %beta(79), b121 = %beta(80) , c121 = %beta(81), d121 = %beta(82), e121 = %beta(83), f121=%beta(84)$
, a120 = %beta(85), a131 = %beta(86), b131 = %beta(87) , c131 = %beta(88), d131 = %beta(89), e131 = %beta(90), f131=%beta(91)$
, a130 = %beta(92), a141 = %beta(93), b141 = %beta(94) , c141 = %beta(95), d141 = %beta(96), e141 = %beta(97), f141=%beta(98)



com  a11 = (a11+a21+a31+a41+a51+a61+a71+a81+a91+a101+a111+a121+a131+a141)/14
com  b11 = (b11+b21+b31+b41+b51+b61+b71+b81+b91+b101+b111+b121+b131+b141)/14
com  c11 = (c11+c21+c31+c41+c51+c61+c71+c81+c91+c101+c111+c121+c131+c141)/14
com  f11 = (f11+f21+f31+f41+f51+f61+f71+f81+f91+f101+f111+f121+f131+f141)/14
com  d11 = (d11+d21+d31+d41+d51+d61+d71+d81+d91+d101+d111+d121+d131+d141)/14
com  e11 = (e11+e21+e31+e41+e51+e61+e71+e81+e91+e101+e111+e121+e131+e141)/14


**********************************************************************************
* define nonlinear model and estimate it

dis '****Nonlinear Estimation results of Linear SURE panel****'
****Nonlinear Estimation results of Linear SURE panel****

**********************************************************************************
set tvort = ortdmisal{2}


nonlin a0 a1 a11 a21 b11 b21 c11 c21 d11 d21 e11 e21 f11 f21 c

frml start = (-gamma*(tvort-c))/se
frml star = 1+exp(start)
frml starTF = 1/star

frml lstar1 gdp1 = a0+a11*gdp1{1}+b11*gdp1{1}*starTF+c11*ect1{1}+d11*ect1{1}*starTF+e11*dmisal1{1}+f11*dmisal1{1}*starTF
frml lstar2 gdp2 = a0+a11*gdp2{1}+b11*gdp2{1}*starTF+c11*ect2{1}+d11*ect2{1}*starTF+e11*dmisal2{1}+f11*dmisal2{1}*starTF
frml lstar3 gdp3 = a0+a11*gdp3{1}+b11*gdp3{1}*starTF+c11*ect3{1}+d11*ect3{1}*starTF+e11*dmisal3{1}+f11*dmisal3{1}*starTF
frml lstar4 gdp4 = a0+a11*gdp4{1}+b11*gdp4{1}*starTF+c11*ect4{1}+d11*ect4{1}*starTF+e11*dmisal4{1}+f11*dmisal4{1}*starTF
frml lstar5 gdp5 = a0+a11*gdp5{1}+b11*gdp5{1}*starTF+c11*ect5{1}+d11*ect5{1}*starTF+e11*dmisal5{1}+f11*dmisal5{1}*starTF
frml lstar6 gdp6 = a0+a11*gdp6{1}+b11*gdp6{1}*starTF+c11*ect6{1}+d11*ect6{1}*starTF+e11*dmisal6{1}+f11*dmisal6{1}*starTF
frml lstar7 gdp7 = a0+a11*gdp7{1}+b11*gdp7{1}*starTF+c11*ect7{1}+d11*ect7{1}*starTF+e11*dmisal7{1}+f11*dmisal7{1}*starTF
frml lstar8 gdp8 = a0+a11*gdp8{1}+b11*gdp8{1}*starTF+c11*ect8{1}+d11*ect8{1}*starTF+e11*dmisal8{1}+f11*dmisal8{1}*starTF
frml lstar9 gdp9 = a0+a11*gdp9{1}+b11*gdp9{1}*starTF+c11*ect9{1}+d11*ect9{1}*starTF+e11*dmisal9{1}+f11*dmisal9{1}*starTF
frml lstar10 gdp10 = a0+a11*gdp10{1}+b11*gdp10{1}*starTF+c11*ect10{1}+d11*ect10{1}*starTF+e11*dmisal10{1}+f11*dmisal10{1}*starTF
frml lstar11 gdp11 = a0+a11*gdp11{1}+b11*gdp11{1}*starTF+c11*ect11{1}+d11*ect11{1}*starTF+e11*dmisal11{1}+f11*dmisal11{1}*starTF
frml lstar12 gdp12 = a0+a11*gdp12{1}+b11*gdp12{1}*starTF+c11*ect12{1}+d11*ect12{1}*starTF+e11*dmisal12{1}+f11*dmisal12{1}*starTF
frml lstar13 gdp13 = a0+a11*gdp13{1}+b11*gdp13{1}*starTF+c11*ect13{1}+d11*ect13{1}*starTF+e11*dmisal13{1}+f11*dmisal13{1}*starTF
frml lstar14 gdp14 = a0+a11*gdp14{1}+b11*gdp14{1}*starTF+c11*ect14{1}+d11*ect14{1}*starTF+e11*dmisal14{1}+f11*dmisal14{1}*starTF
frml lstar15 dmisal1 = a1+a21*gdp1{1}+b21*gdp1{1}*starTF+c21*ect1{1}+d21*ect1{1}*starTF+e21*dmisal1{1}+f21*dmisal1{1}*starTF
frml lstar16 dmisal2 = a1+a21*gdp2{1}+b21*gdp2{1}*starTF+c21*ect2{1}+d21*ect2{1}*starTF+e21*dmisal2{1}+f21*dmisal2{1}*starTF
frml lstar17 dmisal3 = a1+a21*gdp3{1}+b21*gdp3{1}*starTF+c21*ect3{1}+d21*ect3{1}*starTF+e21*dmisal3{1}+f21*dmisal3{1}*starTF
frml lstar18 dmisal4 = a1+a21*gdp4{1}+b21*gdp4{1}*starTF+c21*ect4{1}+d21*ect4{1}*starTF+e21*dmisal4{1}+f21*dmisal4{1}*starTF
frml lstar19 dmisal5 = a1+a21*gdp5{1}+b21*gdp5{1}*starTF+c21*ect5{1}+d21*ect5{1}*starTF+e21*dmisal5{1}+f21*dmisal5{1}*starTF
frml lstar20 dmisal6 = a1+a21*gdp6{1}+b21*gdp6{1}*starTF+c21*ect6{1}+d21*ect6{1}*starTF+e21*dmisal6{1}+f21*dmisal6{1}*starTF
frml lstar21 dmisal7 = a1+a21*gdp7{1}+b21*gdp7{1}*starTF+c21*ect7{1}+d21*ect7{1}*starTF+e21*dmisal7{1}+f21*dmisal7{1}*starTF
frml lstar22 dmisal8 = a1+a21*gdp8{1}+b21*gdp8{1}*starTF+c21*ect8{1}+d21*ect8{1}*starTF+e21*dmisal8{1}+f21*dmisal8{1}*starTF
frml lstar23 dmisal9 = a1+a21*gdp9{1}+b21*gdp9{1}*starTF+c21*ect9{1}+d21*ect9{1}*starTF+e21*dmisal9{1}+f21*dmisal9{1}*starTF
frml lstar24 dmisal10 = a1+a21*gdp10{1}+b21*gdp10{1}*starTF+c21*ect10{1}+d21*ect10{1}*starTF+e21*dmisal10{1}+f21*dmisal10{1}*starTF
frml lstar25 dmisal11 = a1+a21*gdp11{1}+b21*gdp11{1}*starTF+c21*ect11{1}+d21*ect11{1}*starTF+e21*dmisal11{1}+f21*dmisal11{1}*starTF
frml lstar26 dmisal12 = a1+a21*gdp12{1}+b21*gdp12{1}*starTF+c21*ect12{1}+d21*ect12{1}*starTF+e21*dmisal12{1}+f21*dmisal12{1}*starTF
frml lstar27 dmisal13 = a1+a21*gdp13{1}+b21*gdp13{1}*starTF+c21*ect13{1}+d21*ect13{1}*starTF+e21*dmisal13{1}+f21*dmisal13{1}*starTF
frml lstar28 dmisal14 = a1+a21*gdp14{1}+b21*gdp14{1}*starTF+c21*ect14{1}+d21*ect14{1}*starTF+e21*dmisal14{1}+f21*dmisal14{1}*starTF

compute gamma = 5.941074284
compute c = -0.16189

nlpar(cvcr=0.00000000001,subit=150)	
nlsystem(iter=150,isigma=sn,print,robust,damp=1,lag=4,resid=Resids) /  lstar1  lstar2 lstar3 lstar4 lstar5 lstar6 lstar7 lstar8  lstar9 lstar10 lstar11 lstar12 lstar13 lstar14 lstar15 lstar16 lstar17 lstar18 lstar19 lstar20 lstar21 lstar22 lstar23 lstar24 lstar25 lstar26 lstar27 lstar28

***********************************************************
dis '*****************Granger Causality Results**********************'
*****************Granger Causality Results**********************
*** Granger Causality Test
* Short run Causality
test
#  7
# 0.0  0.0

test
#  5
# 0.0  0.0

test
#  3    5
# 0.0  0.0 0.0

test
#  10
# 0.0  0.0


open copy "F:\Users\PhD Thesis\PhD Papers\Paper 3\Sure1\Resids.xls" / Resids
copy(dates,format=xls,org=colums) / Resids
*display named

****************0 *******************************************
dis '*****************Granger Causality Results**********************'
*** Granger Causality Test
test
# 4
# 0.0

test
#  8
# 0.0

test
#  4    8
# 0.0  0.0

test
#  4 6
# 0.0  0.0

test
#  8 10
# 0.0  0.0

test
#  8 10 4 6
# 0.0  0.0 0.0 0.0


dis '****************Transition fn wrt to transition variable*******************'
***Graphics by using the nonlinear estimation results Transition fn wrt to transition variable*******************


set tv2 = ortdmisal{2} ; stat(print) tv2; comp sd = sqrt(%variance)

* logistic transition function'i tanimla

set tfl = 1.0 / (1.0 + exp(-5.941*(tvort+0.102146010)/sd))

open copy "F:\Users\PhD Thesis\PhD Papers\Paper 3\Sure1\tv.xls" / tv2 tfl
copy(dates,format=xls,org=colums) / tv2 tfl
*display named

* logistic transition function'in grafigini ciz

* graph 1 ; # tf
scatter(style=symb,hmax=0.40,hmin=-1.20, axis=none) 1
# tv2 tfl












